﻿//////////////////////////////////////////////
// TextureManagerWrapper.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkScripts
{
	class Environment ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../../Dll/DllDefines.h"

// nkScripts
#include <NilkinsScripts/Environments/Functions/Function.h>

/// Class ------------------------------------

namespace nkAstraeus::nkGraphicsWrap
{
	class DLL_ASTRAEUS_EXPORT TextureManagerWrapper final
	{
		public :

			// Mise en place environnement
			static void updateEnvironment (nkScripts::Environment* env) ;

			// Callbacks qui seront appelés suivant les fonctions
			static nkScripts::OutputValue createOrRetrieve (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue get (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue rename (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue erase (const nkScripts::DataStack& stack) ;
	} ;
}